'use client'; // این خط را بالای فایل اضافه کنید
import {clients} from "@/app/data/clients.json"

import {motion} from 'framer-motion';

export function ClientLogos() {
    let logos = [...clients].sort(() => Math.random() - 0.5);

    return (
        <div className="logos">
            {/*<p className="color-secondary">The World’s Leading Chemical Companies</p>*/}
            {/*<p className="bold" style={{color: "#6F6F6F"}}>Our clients are industry leaders who trust us <br/>*/}
            {/*    to deliver date-driven solutions and expert insights</p>*/}
            {/*<p style={{width: "100%"}}>At TranTech Consultants, Inc., we are honored to work with some of the most*/}
            {/*    respected names in*/}
            {/*    the*/}
            {/*    Chemical Process Industries. Our clients are industry leaders who trust us to deliver*/}
            {/*    date-driven*/}
            {/*    solutions, expert insights, and cutting-edge tools that drive their success. Together, we are*/}
            {/*    shaping*/}
            {/*    the future of the chemical industry.</p>*/}

            {logos.map((client, index) => (
                <motion.div
                    key={client.id}
                    className="logo"
                    initial={{scale: 0}}
                    animate={{scale: 1}}
                    transition={{
                        delay: index * 0.05,
                        type: "spring",
                        stiffness: 100,
                    }}
                >
                    <img src={client.img} alt={client.name}/>
                </motion.div>
            ))}
        </div>
    );
}