"use client";

import { useEffect } from "react";

export default function ReplaceTM() {
    useEffect(() => {
        const forbiddenTags = ['SCRIPT', 'STYLE', 'SUP', 'NOSCRIPT'];
        const regex = /(\b\w+?)TM\b/g;

        const walkAndReplace = (node) => {

            if (node.nodeType === Node.ELEMENT_NODE && forbiddenTags.includes(node.tagName)) return;


            if (node.nodeType === Node.TEXT_NODE && node.nodeValue.includes("TM")) {
                const newHTML = node.nodeValue.replace(regex, '$1<sup>TM</sup>');

                if (newHTML !== node.nodeValue) {
                    const wrapper = document.createElement("span");
                    wrapper.innerHTML = newHTML;
                    node.parentNode.replaceChild(wrapper, node);
                }
            } else {

                node.childNodes.forEach(walkAndReplace);
            }
        };

        walkAndReplace(document.body);
    }, []);

    return null;
}
