import {BlurPublicImage} from "@/app/components/BlurImage";
import {CountUp} from "@/app/components/CountUp";
import {Carousel_Logos} from "@/app/components/carousel/Carousel_Logos";
import {BookDemo_BTN} from "@/app/components/buttons/BookDemo_Btn";
import {MainLayout} from "@/app/layouts/MainLayout";
import {ChemplanWorkspace_BTN} from "@/app/components/buttons/ChempanWorkspace_Btn";
import {generateMetadata} from "@/app/helpers/generateMetadata";
import {Carousel_Services} from "@/app/components/carousel/Carousel_services";

export const metadata = generateMetadata({
    title: "TranTech Consultants, Inc.: chemical process Engineering & Investment",
    description: "Optimize chemical, petrochemical & polymer projects with precision planning, advanced investment & engineering solutions. Enhance CAPEX and ROI now.",
    keywords: "precision process engineering, integrated investment analysis, advanced chemical planning, polymer project optimization, techno-economic modeling, risk-based CAPEX strategy"
})

export default function Home() {
    return (<MainLayout>

            <div id="page-container" className="container-fluid page-content">

                <div id="home" className="content">

                    <div className="page-title">
                        <p className="uppercase">Leader for the data-driven decision making in chemical process
                            industries</p>
                        <h2>
                            Empowering the chemical process industry with
                            strategic intelligence and engineering excellence
                        </h2>
                        <p>Driving innovation, optimizing operations, and advancing sustainability for a competitive
                            future</p>

                    </div>

                </div>


                <div id="yearsIndustryTrust" style={{margin: "3rem 0"}} className="content">
                    <div className="container">

                        <p>Welcome to TranTech Consultants Inc. where we provide integrated solutions that transform
                            complex industrial challenges into actionable opportunities. We have built a legacy of over
                            40 years by combining deep technical expertise with advanced data analytics and strategic
                            market intelligence for the chemical, petrochemical, and sustainability sectors.</p>

                        <div style={{padding: "2rem 0"}} className="page-title">
                            <h2>
                                TranTech Consultants, Inc.: 40+ years of<br/>
                                proven excellence and enduring industry trust
                            </h2>
                            <p>
                                Trusted industry expertise at the intersection of innovation, sustainability, and
                                engineering excellence, since 1981
                            </p>
                        </div>


                        <div className="column">
                            <div className="cards">
                                <div className="card">
                                    <h3>Decades of proven expertise
                                    </h3>
                                    <p>Our legacy spans over 40 years in the chemical process industry, built on a
                                        foundation of consistent performance, reliability, and technical prowess. We
                                        have continually evolved with the market, earning the trust of industry leaders
                                        by delivering results through rigorous engineering, strategic advisory, and deep
                                        market insights.</p>
                                </div>

                                <div className="card">
                                    <h3>Innovative, data-driven solutions
                                    </h3>
                                    <p>We leverage advanced analytics and proprietary tools such as the ChemPlan™
                                        Workspace to transform complex data into actionable intelligence. By fusing
                                        traditional engineering expertise with innovative digital insights, we empower
                                        professionals to make precise, informed decisions that drive operational
                                        efficiency and competitive growth.
                                    </p>
                                </div>

                                <div className="card">
                                    <h3>Comprehensive end-to-end engineering
                                    </h3>
                                    <p>Our solutions cover every stage of the process—from initial concept studies and
                                        strategic planning to finalized engineering designs and debottlenecking
                                        measures. This integrated approach ensures that every technical and operational
                                        challenge is met with tailored, expert strategies that optimize production and
                                        elevate quality standards.</p>
                                </div>


                                <div className="card">
                                    <h3>Dynamic market and strategic advisory
                                    </h3>
                                    <p>We provide a robust suite of services that includes detailed market analysis,
                                        competitive benchmarking, and intelligent pricing strategies, all designed to
                                        deliver real-time, actionable insights. Our strategic advisory services offer
                                        expert guidance on risk management, technology screening, and market positioning
                                        to secure long-term success.</p>
                                </div>

                                <div className="card">
                                    <h3>Strategic partnerships
                                    </h3>
                                    <p>Our approach is centered around building strong alliances with industry leaders,
                                        research institutions, and technology innovators. By co-developing breakthrough
                                        solutions and sharing best practices, we create synergies that drive
                                        transformative change. This collaborative ecosystem enhances our collective
                                        expertise and provides us a continuous flow of fresh, actionable insights.</p>
                                </div>

                                <div className="card">
                                    <h3>Commitment to sustainability
                                    </h3>
                                    <p>In today’s evolving regulatory and environmental landscape, our expertise extends
                                        into sustainable practices that include decarbonization roadmaps, hydrogen
                                        economy integration, and waste-to-product strategies. We help clients balance
                                        economic growth with environmental responsibility, ensuring a resilient and
                                        sustainable future for their operations.</p>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>

                <div className="content padding-0 d-flex ">
                    <BlurPublicImage className="img-full-width" src="/img/home/smart-background.webp"
                                     alt={"Home pages smart planing Image"}

                                     width={4545} height={2727}/>

                </div>

                <div id="streamlining-data" className="content">
                    <div className="container">

                        <div style={{padding: "2rem 0"}} className="page-title">
                            <p>
                                TranTech Consultants’ services are your solution to information overload </p>
                            <h2>
                                Streamlining data for smarter decisions
                            </h2>
                        </div>


                        <div className="row">
                            <div className="col-10 streamlining-content" style={{position: "relative", zIndex: 2}}>
                                <p>
                                    At TranTech Consultants Inc., our legacy of over 40 years is built on delivering
                                    innovative solutions and trusted expertise to the chemical process industry. Our
                                    flagship product, ChemPlan™ Workspace, is an exclusive, fully integrated worldwide
                                    database that compiles site- and technology-specific process-product information
                                    alongside critical metrics such as supply and demand, market share, import/export
                                    data, and detailed insights on plants, producers, and production or investment
                                    costs. Covering over 5,000 producers, 9,000 plants, 8,000 processes, 3,500 products,
                                    and 2,000 markets, ChemPlan™ Workspace encompasses vital data on organic
                                    intermediate chemicals, commodities, specialty chemicals, and polymers such as
                                    water-soluble polymers, polyurethanes, and superabsorbent polymers. Designed to
                                    reduce information overload and streamline strategic decision-making, our
                                    comprehensive database and extensive industry experience empower professionals to
                                    make informed, cost-effective choices swiftly and confidently.
                                </p>
                            </div>
                        </div>

                    </div>
                </div>

                <div id="leading-global" className="content">

                    <div className="column container">
                        <div className="row leading-global-database">
                            <div className="card">
                                <BlurPublicImage src={"/img/svg/home/Producers icon.svg"} width={200}
                                                 height={200}/>

                                <span>More than</span>
                                <h3><CountUp start={123} end={5000} step={121} duration={2000}/>
                                </h3>
                                <p>Chemical<br/>
                                    Producers</p>
                            </div>

                            <div className="card">
                                <BlurPublicImage src={"/img/svg/home/Chemical processes icon.svg"} width={200}
                                                 height={200}/>

                                <span>More than</span>
                                <h3><CountUp start={123} end={8000} step={121} duration={2000}/>
                                </h3>
                                <p>Chemical<br/>
                                    Processes</p>
                            </div>

                            <div className="card">
                                <BlurPublicImage src={"/img/svg/home/Chemical plants icon.svg"} width={200}
                                                 height={200}/>
                                <span>More than</span>
                                <h3><CountUp start={323} end={9000} step={321} duration={2000}/>
                                </h3>
                                <p>Plants <br/>
                                    Worldwide</p>

                            </div>

                            <div className="card">
                                <BlurPublicImage src={"/img/svg/menu/Material property insights.svg"} width={200}
                                                 height={200}/>
                                <span>More than</span>
                                <h3><CountUp start={32} end={3500} step={45} duration={2000}/>
                                </h3>
                                <p>Chemical<br/>
                                    Products</p>
                            </div>


                            <div className="card">
                                <BlurPublicImage src={"/img/svg/home/Market information icon.svg"} width={200}
                                                 height={200}/>

                                <span>More than</span>
                                <h3><CountUp start={12} end={2000} step={32} duration={2000}/>
                                </h3>
                                <p>Market<br/>
                                    Information</p>
                            </div>

                        </div>
                    </div>

                </div>


                <div id="client-logos" className="content container">
                    <div style={{padding: "2rem 0"}} className="page-title">
                        <h2>
                            Trusted by the giants
                        </h2>
                        <h3>of the world’s chemical process industry</h3>
                    </div>
                    <Carousel_Logos/>
                </div>


                <div className="content " id="our-services-slider">
                    <div style={{padding: "2rem 0"}} className="page-title container">
                        <h2>
                        Innovative engineered solutions for a dynamic industry
                        </h2>
                        <p>At TranTech Consultants Inc., we integrate decades of experience with state-of-the-art
                            technology to transform complex challenges into actionable solutions. Our multidisciplinary
                            approach blends rigorous data analytics, expert engineering, and strategic foresight to
                            empower industry professionals. We believe that every project begins with a strong
                            foundation of insight, and our comprehensive solutions are designed to guide you seamlessly
                            from initial concept to fully realized operational excellence in today’s rapidly evolving
                            chemical process industry.</p>
                    </div>

                    <div className="container">
                        <Carousel_Services/>

                    </div>
                </div>


                <div id="world-wide" className="content container">

                    <div className="row">
                        <div className="col-6 world-wide-content">
                            <div style={{padding: "2rem 0"}} className="page-title">
                                <p style={{marginBottom: "20px"}}>From every plant, process, and market across the
                                    globe, we deliver granular, up-to-date data tailored to your needs</p>
                                <h2>
                                    Worldwide detailed data for
                                    the chemical process industry,
                                    right at your fingertips!
                                </h2>
                            </div>

                            <p>
                                Access to precise, real-time industry data is essential for making informed decisions in
                                the ever-evolving chemical process industry. At TranTech Consultants Inc., we provide a
                                fully integrated, worldwide database that delivers detailed insights into processes,
                                market trends, production costs, supply and demand dynamics, and competitive
                                intelligence.
                                <br/>
                                <br/>
                                Our proprietary knowledge platform, ChemPlan<sup>TM</sup> Workspace, offers an extensive
                                repository of technology-specific process-product data, covering critical aspects such
                                as production and investment costs, supply and demand analysis, market share and
                                competitive benchmarking, technology and process integration data, and import and export
                                analytics. <br/>
                                ChemPlan<sup>TM</sup> Workspace eliminates the inefficiencies of data overload by
                                consolidating industry intelligence into one powerful, accessible platform. Whether
                                refining market strategies, evaluating new investments, or optimizing operations, our
                                extensive database ensures professionals have the most relevant, actionable
                                insights—right when they need them.
                            </p>
                            <br/>
                            <br/>

                            <BookDemo_BTN Title={<>Book a ChemPlan<sup>TM</sup> demo</>}/>
                            <br/>
                            <ChemplanWorkspace_BTN/>
                            <br/>
                            <br/>
                            <br/>


                            <p>
                                Book a demo today and take the first step toward smarter, faster, and more confident
                                decisions. With ChemPlan<sup>TM</sup> Workspace, the world of chemical intelligence is
                                in your
                                hands.
                            </p>
                        </div>
                        <div className="col-4 world-wide-image">
                            {/*<img src="/img/earth.jpg" alt=""/>*/}
                            <BlurPublicImage
                                style={{position: "absolute", width: "40%", paddingTop: "100px", paddingLeft: "30px"}}
                                className="img-full-width"
                                src="/img/home/Blue Globe Full.webp" alt={"Blue Globe"} width={915}
                                height={1062}/>

                        </div>
                    </div>


                </div>

                <div className="blue-section">
                    <div className="container">
                        <h2>Why choose TranTech consultants?</h2>
                        <p className="color-secondary">Decades of expertise, powered by unrivaled chemical industry
                            intelligence</p>
                        <p>At TranTech Consultants Inc., we go beyond conventional industry solutions—we deliver
                            precision-driven intelligence, strategic expertise, and cutting-edge engineering tailored to
                            meet the evolving demands of the chemical process industry. With over 40 years of
                            experience, we have built a reputation for trust, accuracy, and innovation, ensuring that
                            professionals worldwide can make informed, cost-effective decisions backed by deep market
                            insights and technical excellence. </p>
                    </div>
                </div>
                <div className="light-blue-section">
                    <div className="container">
                        <ul className="square-blue-list" style={{marginBottom: "1rem"}}>

                            <li>
                                <p><span style={{fontWeight: "bold"}}>Industry-leading expertise – </span>
                                    <span>Decades of experience delivering strategic, engineering, and market intelligence solutions to global leaders.</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Data-driven decision-making – </span>
                                    <span>Exclusive, fully integrated databases, offering unparalleled insights into process technologies, market trends, production costs, and competitive benchmarking.</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Innovative, tailored solutions – </span>
                                    <span>Comprehensive advisory, engineering design, sustainability strategies, and process optimization services designed to maximize efficiency and profitability.</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Commitment to sustainability – </span>
                                    <span>Expertise in decarbonization, hydrogen economy integration, and waste-to-product solutions, helping clients meet environmental and regulatory challenges.</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Proven market strategy – </span>
                                    <span>Advanced forecasting, segment analysis, and competitor intelligence ensuring optimal positioning in a dynamic industry.</span>
                                </p>
                            </li>
                        </ul>

                        <p className="color-primary bold" style={{fontSize: "1.2rem"}}>We understand the complexities of
                            industrial decision-making and provide practical, actionable solutions.</p>


                    </div>
                </div>

                <div className="container talk-to-an-expert">
                    <div>
                        <BlurPublicImage src={"/img/svg/Talk.svg"} alt={"Talk to an expert"} width={200} height={100}/>

                    </div>
                    <div>
                        <h3 className="color-primary">Talk to an expert</h3>
                        <br/>
                        <p className="bold">
                            Need strategic guidance for your chemical business?</p>
                        <br/>
                        <p>Unlock industry-leading strategic guidance, engineering solutions, and market intelligence by
                            speaking directly with a TranTech Consultant expert. Whether you're looking for tailored
                            recommendations, technical assessments, or in-depth process evaluations, our seasoned
                            professionals are ready to help you navigate challenges, seize opportunities, and optimize
                            your operations. We provide personalized consultations designed to address your specific
                            business needs.
                            <br/>
                            <br/>

                            Contact us today to schedule a consultation with a TranTech industry expert and discover how
                            our solutions can transform your business.
                        </p>
                        <br/>

                        <button className="btn-blue">Book a demo call<i className="fa-regular fa-arrow-right"></i>
                        </button>
                        <br/>
                        <button className="btn-blue">Contact us<i className="fa-regular fa-arrow-right"></i></button>


                    </div>
                </div>

            </div>
        </MainLayout>

    );
}
