import {BlurPublicImage} from "@/app/components/BlurImage";
import {CountUp} from "@/app/components/CountUp";
import {BookDemo_BTN} from "@/app/components/buttons/BookDemo_Btn";
import {ChemplanWorkspace_BTN} from "@/app/components/buttons/ChempanWorkspace_Btn";
import {SignUp_BTN} from "@/app/components/buttons/SignUp_Btn";
import {generateMetadata} from "@/app/helpers/generateMetadata";

export const metadata = generateMetadata({
    title: "ChemPlan Workspace: AI-Powered DSS for Chemical Process Investment",
    description: "Discover ChemPlan Workspace - an AI-powered DSS streamlining planning, investment & risk control for chemical, petrochemical & polymer ops.",
    keywords: "integrated process analytics, techno-economic modeling, AI chemical DSS, risk control investment, data-driven market insights"
})

const ChemPlanWorkspace = () => {

    return (<div className="container-fluid">
            <div className=" page-content">

                <div className="page-title">
                    <div className="container">
                        <h2>ChemPlan<sup>TM</sup> Workspace</h2>

                        <p className="color-secondary">AI-powered decision support system for the chemical process
                            industry</p>
                        <br/>
                    </div>


                </div>
                <div className="image">
                    <BlurPublicImage src="/img/products/technology.webp" width={4135} height={2325} alt="technology"/>
                </div>

                <div id="streamlining-data" className="content container">

                    <div  style={{padding:"2rem 0"}} className="page-title">
                        <p>
                            TranTech's ChemPlan is Your Solution to Information Overload
                        </p>
                        <h2>
                            Streamlining Data for Smarter Decisions
                        </h2>
                    </div>


                    <div className="row">
                        <div className="col-5 streamlining-content" style={{position: "relative", zIndex: 2}}>
                            <p>
                                Managers in the Chemical Process Industries (CPI) often need to select one course of
                                action
                                among many alternatives. Since they don't have the time to extract, study and analyze
                                vast
                                amounts of raw data from numerous sources, TranTech Consultants, Inc. developed ChemPlan
                                specifically to reduce information overload, enabling them to spend more time with their
                                strategic decision making. Consequently, they can make more competent and cost effective
                                decisions.
                            </p><br/>
                            <p>ChemPlan is a powerful, knowledge-based system with an extensive, multifaceted library
                                covering
                                all aspects of a chemical. It combines worldwide dynamic data and built-in expert models
                                that
                                result in an indispensable tool for decision makers in the CPI.
                            </p>
                        </div>
                        <div className="col-5 imageSide">
                            <BlurPublicImage className="img-full-width" src="/img/products/streamlining.png"
                                             alt={"streamlining"}
                                             width={1039}
                                             height={636}/>

                        </div>
                    </div>

                </div>
                <div id="leading-global" className="content container">

                    <div  style={{padding:"2rem 0", marginTop:"3rem"}} className="page-title">
                        <h2>
                            The Leading Global Database for Chemical Process Industries
                        </h2>
                        <p>
                            ChemPlan is an exclusive, fully integrated, worldwide database containing site and
                            technology
                            specific process-product information, as well as supply-demand, market share, import,
                            export,
                            plant and producer, and production-investment cost data on specific classes of chemicals.
                            Over
                            5,000 producers, 9,000 plants, 8,000 processes, 3,500 products, and 2,000 markets are
                            covered,
                            including: Water-Soluble Polymers, Polyurethane Chemicals, Super absorbent Polymers, Organic
                            Intermediate Chemicals, and commodity/speciality polymers. </p>
                    </div>


                    <div className="column">
                        <div className="row leading-global-database">

                            <div className="column">
                                <div style={{width: "100%"}} className="card">
                                    <span>More than</span>
                                    <h3><CountUp start={123} end={5000} step={121} duration={2000}/>
                                    </h3>
                                    <p>Chemical<br/>
                                        Producers</p>
                                </div>

                                <div style={{width: "100%"}} className="card">
                                    <span>More than</span>
                                    <h3><CountUp start={123} end={8000} step={121} duration={2000}/>
                                    </h3>
                                    <p>Chemical<br/>
                                        Processes</p>
                                </div>
                            </div>

                            <div className="column">

                                <div style={{height: "100%", width: "100%"}} className="card active">
                                    <span>More than</span>
                                    <h3><CountUp start={323} end={9000} step={321} duration={2000}/>
                                    </h3>
                                    <p>Plants <br/>
                                        Worldwide</p>

                                </div>
                            </div>

                            <div className="column">

                                <div style={{width: "100%"}} className="card">
                                    <span>More than</span>
                                    <h3><CountUp start={32} end={3500} step={45} duration={2000}/>
                                    </h3>
                                    <p>Chemical<br/>
                                        Products</p>
                                </div>


                                <div style={{width: "100%"}} className="card">
                                    <span>More than</span>
                                    <h3><CountUp start={12} end={2000} step={32} duration={2000}/>
                                    </h3>
                                    <p>Market<br/>
                                        Information</p>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
                <div className="image">
                    <BlurPublicImage src="/img/products/technology2.webp" width={4135} height={2325} alt="technology"/>
                </div>

                <div className="services">

                    <div className="service row">
                        <div className="service-icon">
                            <BlurPublicImage src="/img/svg/menu/Market insights.svg" width={4135} height={2325}
                                             alt="Market insights"/>

                        </div>
                        <div className="service-desc">
                            <h2>Market insights</h2>
                            <p className="subtitle color-secondary">Regional and global market Insights</p>
                            <br/>
                            <p className="desc">In today's interconnected chemical industry, understanding market
                                dynamics is critical to staying competitive. With ChemPlan's Market Insights, you gain
                                access to a panoramic view of chemical markets, powered by comprehensive data spanning
                                500+ markets globally. From regional capacities and outputs to imports, exports, and
                                consumption trends, our tools provide the depth and breadth of information you need to
                                make informed decisions.<br/>
                                Whether you're analyzing market share breakdowns, forecasting growth trends, or
                                identifying emerging opportunities, ChemPlan equips you with the insights to anticipate
                                market shifts and refine your global strategy with confidence. Updated annually—or as
                                major changes occur—our data ensures you're always working with the most accurate and
                                up-to-date information.</p>
                        </div>
                    </div>

                    <div className="service row-reverse">
                        <div className="service-icon">
                            <BlurPublicImage src="/img/svg/menu/Company-Product insights.svg" width={4135} height={2325}
                                             alt="Company-Product insights"/>

                        </div>
                        <div className="service-desc">
                            <h2>Company-Product insights</h2>
                            <p className="subtitle color-secondary">Company- and application-specific Product data</p>
                            <br/>
                            <p className="desc">In the competitive landscape of the chemical industry, understanding
                                your competitors and their products is key to staying ahead. With ChemPlan's Workspace,
                                you gain access to a rich repository of data covering 6,000+ producers, 8,000+ plants,
                                and 1,000+ products. From detailed company profiles and plant-specific outputs to trade
                                name specifics, regional pricing, and application/end-use data, this product provides
                                the actionable intelligence you need to benchmark competitors, explore market entry
                                opportunities, and tailor products to specific industries like adhesives, coatings, and
                                more.<br/>
                                Updated weekly for plants and processes, our data ensures you're always working with the
                                most current and accurate information. Whether you're analyzing competitor strategies,
                                identifying gaps in the market, or optimizing your product portfolio, Company-Product
                                Insights empowers you to make smarter, data-driven decisions.</p>
                        </div>
                    </div>

                    <div className="service row">
                        <div className="service-icon">
                            <BlurPublicImage src="/img/svg/menu/Technology screening.svg" width={4135} height={2325}
                                             alt="Technology screening"/>

                        </div>
                        <div className="service-desc">
                            <h2>Technology screening</h2>
                            <p className="subtitle color-secondary">Technology database for chemical processes</p>
                            <br/>
                            <p className="desc">Innovation and efficiency in the chemical industry begin with a deep
                                understanding of processes and technologies. With Technology Screening of ChemPlan
                                Workspace, you gain access to a vast database of 6,000+ chemical processes, detailing
                                everything from processing steps and reaction conditions (temperature, pressure, time)
                                to multi-product plant outputs. Covering key classes like Water-Soluble Polymers,
                                Polyurethane Chemicals, and more, this resource is your ultimate tool for evaluating
                                technologies, optimizing production methods, and driving innovation.<br/>
                                Updated weekly with four major annual revisions, our database ensures you're always
                                working with the most accurate and up-to-date information. Whether you're a process
                                engineer refining operations or an R&D team exploring new technologies, Technology
                                Screening provides the technological foundation you need to succeed.</p>
                        </div>
                    </div>

                    <div className="service row-reverse">
                        <div className="service-icon">
                            <BlurPublicImage src="/img/svg/menu/Process insights.svg" width={4135} height={2325}
                                             alt="Process insights"/>

                        </div>
                        <div className="service-desc">
                            <h2>Process insights</h2>
                            <p className="subtitle color-secondary">Technical equipment and process insights</p>
                            <br/>
                            <p className="desc">In the chemical industry, the right equipment and process optimization
                                can make all the difference. With ChemPlan’s Process Insights, you gain a technical edge
                                through in-depth insights into equipment and process performance. This product provides
                                detailed information on major equipment types, sizes, materials of construction, as well
                                as compatibility data (solvents, emulsions) and solution properties (viscosity, surface
                                tension). Whether you’re selecting equipment, troubleshooting processes, or optimizing
                                performance, Process Insights is your go-to resource for engineering excellence.<br/>
                                Perfect for engineers and operations teams, ChemPlan Workspace supports a wide range of
                                chemical applications, helping you achieve peak efficiency and reliability in your
                                operations.</p>
                        </div>
                    </div>

                    <div className="service row">
                        <div className="service-icon">
                            <BlurPublicImage src="/img/svg/menu/Cost estimation models.svg" width={4135} height={2325}
                                             alt="Cost estimation models"/>

                        </div>
                        <div className="service-desc">
                            <h2>Cost estimation models</h2>
                            <p className="subtitle color-secondary">Investment and production costs analysis</p>
                            <br/>
                            <p className="desc">In the competitive chemical industry, every financial decision counts.
                                With ChemPlan's Cost Estimation models, you gain the tools to make informed financial
                                decisions through granular cost analyses for chemical processes and production. Assess
                                total investment needs—including design capacity, equipment, utilities, and working
                                capital—and dive into detailed production costs such as raw materials, labor,
                                depreciation, and waste treatment. Featuring sortable cost charts by net production cost
                                (NPC), this tool helps you minimize expenses, evaluate ROI, and enhance profitability in
                                a competitive landscape.<br/>
                                Available in both SI (Metric) and US/British units, Cost Estimation is designed to meet
                                the needs of global decision-makers, ensuring accuracy and flexibility in your financial
                                planning.</p>
                        </div>
                    </div>

                    <div className="service row-reverse">
                        <div className="service-icon">
                            <BlurPublicImage src="/img/svg/menu/Strategic decision making.svg" width={4135}
                                             height={2325}
                                             alt="Strategic decision making"/>

                        </div>
                        <div className="service-desc">
                            <h2>Strategic decision making</h2>
                            <p className="subtitle color-secondary">Strategic decision support system</p>
                            <br/>
                            <p className="desc">In the fast-paced world of the Chemical Process Industries (CPI),
                                strategic decisions can make or break your success. With ChemPlan Workspace as a
                                Strategic Decision Support System, you gain access to a dynamic suite of tools designed
                                to elevate your strategic planning. This product empowers you to tackle complex
                                challenges with confidence.<br/>
                                From simulating “What if?” scenarios—like a competitor's plant upgrade—to analyzing
                                future capacity projections and market trends, this system streamlines decision-making
                                for business development, market entry, and long-term strategy. Updated weekly for
                                plants and processes and annually for markets, ChemPlan Workspace ensures you're always
                                working with the most accurate and up-to-date information.</p>
                        </div>
                    </div>

                    <div className="service row">
                        <div className="service-icon">
                            <BlurPublicImage src="/img/svg/menu/Material property insights.svg" width={4135}
                                             height={2325}
                                             alt="Material property insights"/>

                        </div>
                        <div className="service-desc">
                            <h2>Material property insights</h2>
                            <p className="subtitle color-secondary">Material and product property insights</p>
                            <br/>
                            <p className="desc">In the chemical process industry, understanding the chemical and
                                physical properties of your products is essential for innovation and quality. With
                                ChemPlan's Material Property Insights, you gain access to a robust tool that examines
                                the science behind your materials. From composition (active ingredients, volatiles) and
                                solubility to absorption capacities, catalyst active site properties, film
                                characteristics, and bulk properties (e.g., density, softening temperature), this
                                product is a goldmine for R&D, quality assurance, and product development teams.<br/>
                                Whether you're tweaking formulations, ensuring product quality, or launching new
                                products, ChemPlan Workspace provides the precision and depth you need to innovate with
                                confidence.</p>
                        </div>
                    </div>

                    <div className="service row-reverse active">
                        <div className="service-icon">
                            <BlurPublicImage src="/img/svg/menu/Customized dashboard for you.svg" width={4135}
                                             height={2325}
                                             alt="Customized dashboard for you"/>

                        </div>
                        <div className="service-desc">
                            <h2>Customized dashboard for you</h2>
                            <p className="subtitle color-secondary">Regional and global market Insights</p>
                            <br/>
                            <p className="desc">In today's data-driven world, a one-size-fits-all approach no longer
                                cuts it. With a Customized Dashboard in ChemPlan Workspace, you can transform your
                                workspace into a bespoke solution tailored to your company's unique needs. Visualize
                                your asset and develop a digital twin of your production plants. Build tailored
                                searches, manipulate data and models, and visualize insights that align with your
                                specific goals. Whether you're integrating ChemPlan into your workflows or empowering
                                your team with a user-friendly interface, this product is designed for flexibility and
                                impact.<br/>
                                From customizable search builders to personalized visualizations, the Customized
                                Dashboard puts your data, your way—ensuring you get the most out of the powerful tools
                                provided in ChemPlan Workspace.</p>
                        </div>
                    </div>


                </div>


                <div id="world-wide" className="content container">

                    <div className="row">
                        <div className="col-6 world-wide-content">
                            <div className="page-title">
                                <p style={{marginBottom: "20px"}}>From every plant, process, and market across the
                                    globe,<br/>
                                    ChemPlan Workspace delivers granular, up-to-date data tailored to your needs</p>
                                <h2>
                                    Worldwide detailed data for
                                    the chemical process industry,
                                    right at your fingertips!
                                </h2>
                            </div>

                            <p>
                                In the fast-paced world of the chemical process industries, staying ahead requires more
                                than just data—it demands actionable insights and strategic foresight. With ChemPlan
                                Workspace, you gain access to global data for the chemical process industry right at
                                your fingertips. From the world of polymers and chemicals to <span
                                className="bold color-primary">integrated
                                process-product-market data</span>, ChemPlan brings <span
                                className="bold color-primary">the world’s most comprehensive chemical
                                intelligence</span> directly to you.
                                <br/>
                                <br/>
                                With ChemPlan Workspace you’re equipping your company with the ultimate resource to
                                empower your decisions and drive your success.<br/>
                                Don’t let information overload hold you back. Let us transform raw data into strategic
                                opportunities, giving you the competitive edge you need to thrive in a dynamic industry.
                            </p>
                            <br/>
                            <br/>

                            <BookDemo_BTN Title={<>Book a ChemPlan<sup>TM</sup> demo</>}/>
                            <br/>
                            <SignUp_BTN/>
                            <br/>
                            <br/>


                            <p>
                                Sign up today and take the first step toward smarter, faster, and more confident
                                decisions. With ChemPlan, the world of chemical intelligence is in your hands.
                            </p>
                            <br/>
                            <br/>
                        </div>
                        <div className="col-4 world-wide-image">
                            {/*<img src="/img/earth.jpg" alt=""/>*/}
                            <BlurPublicImage
                                style={{position: "absolute", width: "40%", paddingTop: "100px", paddingLeft: "30px"}}
                                className="img-full-width"
                                src="/img/home/Blue Globe Full.webp" alt={"Blue Globe"} width={915}
                                height={1062}/>

                        </div>
                    </div>


                </div>

            </div>

            <div className="page-content">
                <div className="page-title">
                    <div className="container">
                        <h2>Why do industry leaders choose ChemPlan?</h2>

                        <p className="color-secondary">ChemPlan Workspace is more than just a tool—it’s a game-changer
                            for the Chemical Process Industries. Here’s why industry leaders trust ChemPlan to drive
                            their success</p>
                        <br/>
                    </div>


                </div>

            </div>

            <div id="client" className="content page-content">


                <div id="why-choose" className="inner-content container">
                    <br/>

                    <p>
                        Industry leaders across the chemical, petrochemical, and process sectors trust ChemPlan because
                        it seamlessly combines deep market intelligence with state-of-the-art technology. Designed to
                        transform complex data into actionable insights, ChemPlan Workspace empowers companies to
                        optimize operations, reduce costs, and unlock new growth opportunities.<br/>
                        Industry leaders choose ChemPlan because it transforms the way you view and manage your business
                        operations. It isn’t just about accessing data—it’s about converting that data into strategic
                        actions that drive tangible results, reinforce competitive positioning, and pave the way for
                        sustained growth.
                    </p>
                    <br/>
                    <br/>
                    <br/>

                    <div className="why-choose ">
                        <div className="item">
                            <div className="item-image"><img src="/img/products/ultimated-user.png"
                                                             alt="ultimated-user"/></div>
                            <div className="item-desc">
                                <p className="bold color-primary">Unmatched Expertise</p>
                                <p> Built on 40+ years of industry experience, ChemPlan combines deep domain knowledge
                                    with technology to deliver actionable insights.
                                    <br/>
                                    <br/>
                                    Designed by chemical engineers and industry experts, it addresses the unique
                                    challenges of the Chemical Process Industries.</p>
                            </div>
                        </div>
                        <div className="item">
                            <div className="item-image">
                                <BlurPublicImage src="/img/products/Comprehensive Data Coverage.svg"
                                                 alt=" Comprehensive Data Coverage" width={230} height={120}/>

                            </div>
                            <div className="item-desc">
                                <p className="bold color-primary">Comprehensive Data Coverage</p>

                                <p>Access global data on 6,000+ producers, 8,000+ plants, 6,000+ processes, and 1,000+
                                    products.
                                    <br/>
                                    <br/>
                                    Stay ahead with weekly updates for plant and process data, and annual updates for
                                    market trends.
                                </p>
                            </div>
                        </div>

                        <div className="item">
                            <div className="item-image"><img src="/img/products/Decision-Making.png"
                                                             alt="Decision-Making"/>
                            </div>
                            <div className="item-desc">
                                <p className="bold color-primary">Advanced Decision-Making Tools</p>
                                <p> Leverage 300+ built-in expert models for “What if?” scenarios, cost analyses, and
                                    market forecasts.
                                    <br/>
                                    <br/>
                                    Generate real-time, customizable reports in PDF or Excel formats for seamless
                                    integration into your workflows.
                                </p>
                            </div>
                        </div>
                        <div className="item">
                            <div className="item-image"><img src="/img/products/Tailored Solutions.png"
                                                             alt="Tailored Solutions for Every Need"/></div>
                            <div className="item-desc">
                                <p className="bold color-primary">Tailored Solutions for Every Need</p>

                                <p>ChemPlan Workspace as a SaaS solution for on-demand access, unlimited data and
                                    advanced modeling capabilities.
                                    <br/>
                                    <br/>
                                    Whether you’re a strategic planner, process engineer, or market analyst, ChemPlan
                                    Workspace adapts to your needs.
                                </p>
                            </div>
                        </div>


                        <div className="item">
                            <div className="item-image"><img src="/img/products/trusted by industry.png"
                                                             alt="Trusted by Industry Giants"/></div>
                            <div className="item-desc">
                                <p className="bold color-primary">Trusted by Industry Giants</p>

                                <p> ChemPlan is used by global leaders like BASF, Dow Chemical, ExxonMobil, and Shell to
                                    make smarter, faster, and more confident decisions.
                                    <br/>
                                    <br/>
                                    Join a network of industry pioneers who rely on ChemPlan to stay competitive and
                                    innovative.
                                </p>
                            </div>
                        </div>

                        <div className="item">
                            <div className="item-image"><img src="/img/products/driving innovaition.png"
                                                             alt="Driving Innovation and Efficiency"/></div>
                            <div className="item-desc">
                                <p className="bold color-primary">Driving Innovation and Efficiency</p>
                                <p>From cost optimization and process improvement to market entry strategies, ChemPlan
                                    Workspace empowers you to tackle complex challenges with ease.
                                    <br/>
                                    <br/>
                                    Transform raw data into strategic opportunities and drive growth in a rapidly
                                    evolving industry.
                                </p>
                            </div>
                        </div>

                    </div>

                    <p style={{marginBottom: "25px"}}>Discover how ChemPlan can elevate your decision-making process and
                        position your organization at the forefront of industry innovation. If you’re ready to
                        experience ChemPlan Workspace, we’d love to hear from you. Let’s work together to drive
                        innovation, growth, and success in the chemical industry.</p>
                    <div>
                        <BookDemo_BTN Title={<>Book a ChemPlan<sup>TM</sup> demo</>}/>
                        <br/>
                        <ChemplanWorkspace_BTN/>
                        <br/>
                        <SignUp_BTN/>
                    </div>
                </div>
                <div className="blue-section">
                    <div className="container">
                        <p className="color-secondary">Decades of expertise, powered by unrivaled chemical industry
                            intelligence</p>

                        <h3>Where data meets decision!</h3>
                         <h2>Join our network of industry leaders</h2>

                    </div>
                </div>


                <div className="container talk-to-an-expert">
                    <div>
                        <BlurPublicImage src={"/img/svg/Talk.svg"} alt={"Talk to an expert"} width={200} height={100}/>

                    </div>
                    <div>
                        <h3 className="color-primary">Talk to an expert</h3>
                        <br/>
                        <p className="bold">
                            Need strategic guidance for your chemical business?</p>
                        <p><br/>
                            Have questions or need personalized guidance? Our team of industry experts is here to help!
                            Whether you’re exploring ChemPlan for the first time or looking to maximize its potential
                            for your specific needs, we’re ready to provide the insights and support your need.
                            <br/>
                            <br/>
                            Contact us today to schedule a consultation and discover how ChemPlan Workspace can
                            transform your decision-making process. Let’s turn your challenges into
                            opportunities—together.<br/>
                         </p>                    <br/>

                        <button className="btn-blue">Book a demo call<i className="fa-regular fa-arrow-right"></i>
                        </button>
                        <br/>
                        <button className="btn-blue">Contact us<i className="fa-regular fa-arrow-right"></i></button>


                    </div>
                </div>

            </div>


        </div>

    )
}

export default ChemPlanWorkspace