import {BlurPublicImage} from "@/app/components/BlurImage";

export const metadata = generateMetadata({
    title: "Engineering Design: Innovative Chemical Process Solutions",
    description: "Optimize chemical, petrochemical & polymer projects with TranTech's cutting-edge engineering design solutions. Boost efficiency, reduce CAPEX & mitigate risks.",
    keywords: "integrated design simulation, advanced engineering solutions, chemical process optimization, techno-economic design assessment, risk-mitigated solutions"
})

const Page = () => {
    return (<div className="container-fluid page-content">
            <div className="page-title">
                <div className="container">
                    <h2>Engineering and design</h2>

                    <p className="color-secondary">Precision solutions for process excellence</p>
                    <p style={{fontSize: "1rem"}}>Precision process solutions from conceptual layouts to basic and
                        detailed engineering designs specially for specialty chemicals, polymers, and intermediates</p>
                    <br/>
                </div>
            </div>
            <div className="image">
                    <BlurPublicImage src="/img/webp/solutions/solution2.webp" width={4135} height={2325} alt=""/>


            </div>

            <div className="container">

                <div style={{marginTop:"2rem"}}>
                    <p> Developing efficient and scalable chemical processing systems requires a deep understanding of
                        technology integration, operational optimization, and strategic execution. TranTech Consultants
                        delivers comprehensive engineering and design solutions, helping businesses unlock the full
                        potential of their processes by integrating cutting-edge technologies, digital modeling, and
                        precision engineering. Our approach is data-driven and industry-focused, ensuring that every
                        aspect of plant operations—from technology licensing to process operation optimization—aligns
                        with business objectives.
                    </p>
                    <p>Whether you need technology selection support, existing production line debottlenecking, digital
                        twin implementation, or engineering designs for specialty chemicals, polymers, and
                        intermediates, we provide expert-level engineering services. Our solutions are rooted in decades
                        of industry experience, process fundamentals, economic feasibility, and adaptability to evolving
                        regulations and market dynamics.</p>
                </div>


                <div className="items-list">
                    <div className="item">
                        <div className="title">
                            <div className="title-icon">
                                <BlurPublicImage src={"/img/svg/menu/Providing technology licences.svg"}
                                                 alt={"Providing technology licences"} width={75} height={75}/>
                            </div>
                            <div className="title-text">
                                <h3>
                                    Providing technology licences
                                </h3>
                                <p className="subtitle color-secondary">
                                    Identify and analyze optimal technology partners
                                </p>
                            </div>
                        </div>
                        <div className="desc">
                            <p>
                                The success of any chemical operation depends on selecting the right process
                                technologies. Technology licensing plays a critical role in defining operational
                                efficiency, environmental impact, and production costs. Choosing the most suitable
                                licensed technology ensures businesses maximize yields, optimize energy consumption, and
                                maintain competitive advantages in an evolving marketplace.<br/>
                                TranTech Consultants provides expert guidance on technology identification, analyzing
                                the historical performance and technology selection, cost structures, and scalability of
                                various licensed processes. Our proprietary evaluation framework benchmarks technologies
                                against 8,000+ existing industry processes, helping businesses make data-backed
                                licensing decisions that align with long-term growth and profitability.<br/>

                            </p>
                        </div>
                        <ul className="square-blue-list">
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Technology matching – </span> <span>Identifying optimal process technologies tailored to specific
                                production needs</span></p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Licensor analysis – </span>
                                    <span>Technology screening, techno-economic analysis, and evaluating historical success rates and long-term reliability of technology providers</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Process compatibility assessment – </span> <span>Ensuring seamless integration between existing infrastructure and new licensed technologies</span>
                                </p>
                            </li>
                        </ul>
                    </div>

                    <div className="item">
                        <div className="title">
                            <div className="title-icon">
                                <BlurPublicImage src={"/img/svg/menu/Digital Twins.svg"} alt={"Digital twins"}
                                                 width={75} height={75}/>
                            </div>
                            <div className="title-text">
                                <h3>
                                    Digital twins
                                </h3>
                                <p className="subtitle color-secondary">
                                    Virtual replicas for real-world optimization
                                </p>
                            </div>
                        </div>
                        <div className="desc">
                            <p>
                                Digital twins are transforming the chemical industry by enabling businesses to model,
                                predict, and optimize production processes through real-time virtual simulations. These
                                dynamic data-driven models replicate real-world operations, allowing companies to test,
                                refine, and enhance processes before making costly physical changes.<br/>
                                Our digital twin solutions integrate live operational data with simulation models to
                                provide real-time performance insights. From virtual sensors and predicting equipment
                                failures to optimizing production efficiency, digital twins offer a comprehensive view
                                of system operations, ensuring smarter, more informed decision-making.
                            </p>
                        </div>
                        <ul className="square-blue-list">
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Predictive optimization – </span><span>Simulate and refine production scenarios to enhance efficiency and reduce costs</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Equipment and plant lifecycle monitoring – </span><span>Track degradation rates and predict maintenance needs with high accuracy</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Scalability assessment – </span><span>Model expansion feasibility before committing to physical modifications</span>
                                </p>
                            </li>
                        </ul>
                    </div>


                    <div className="item">
                        <div className="title">
                            <div className="title-icon">
                                <BlurPublicImage src={"/img/svg/menu/Process design packages.svg"}
                                                 alt={"Process design packages"} width={75} height={75}/>
                            </div>
                            <div className="title-text">
                                <h3>
                                    Process design packages
                                </h3>
                                <p className="subtitle color-secondary">
                                    Process design solutions for process technologies
                                </p>
                            </div>
                        </div>
                        <div className="desc">
                            <p>
                                A well-structured process design package serves as the foundation for efficient,
                                scalable, and cost-effective chemical production. Our process designs incorporate highly
                                detailed engineering blueprints, covering everything from process flow diagrams and heat
                                & material balances to equipment specifications and regulatory compliance.<br/>
                                TranTech Consultants specializes in tailoring design packages for specialty chemicals,
                                polymers, intermediates, and commodity processes. Our goal is to ensure that every
                                project follows best engineering practices, maximizing operational efficiency and
                                regulatory alignment while minimizing capital investment risks.
                            </p>
                        </div>
                        <ul className="square-blue-list">
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Conceptual design development – </span><span>Building structured engineering plans for optimized production setups</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Process optimization modeling – </span><span>Enhancing yield, energy consumption, and material efficiency through advanced simulations</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Safety and compliance integration – </span><span>Ensuring adherence to industry regulations and environmental requirements</span>
                                </p>
                            </li>
                        </ul>
                    </div>
                    <div className="item">
                        <div className="title">
                            <div className="title-icon">
                                <BlurPublicImage src={"/img/svg/menu/Basic and Detailed design.svg"}
                                                 alt={"Basic and detailed design"} width={75} height={75}/>
                            </div>
                            <div className="title-text">
                                <h3>
                                    Basic and detailed design
                                </h3>
                                <p className="subtitle color-secondary">
                                    Engineering design for chemical production plants specially Specialties/Polymers/Intermediates
                                </p>
                            </div>
                        </div>
                        <div className="desc">
                            <p>
                                Developing specialized chemical processes demands technical precision and industry
                                expertise to ensure efficiency, scalability, and regulatory compliance. TranTech
                                Consultants, in cooperation with globally recognized engineering partners, provides
                                comprehensive basic and detailed engineering design services tailored to the evolving
                                needs of the chemical, petrochemical, and specialty materials industries.<br/>
                                Our approach integrates industry best practices with advanced technological innovations,
                                allowing clients to optimize production workflows, enhance resource utilization, and
                                minimize operational risks. From initial feasibility studies and process modeling to
                                final execution-ready documentation, we ensure every stage of the design process meets
                                the highest technical and environmental standards.
                            </p>
                        </div>
                        <ul className="square-blue-list">
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Advanced process modeling – </span><span>Utilize industry-leading simulation tools to optimize chemical reaction efficiency, material utilization, and operational workflows</span>
                                </p>
                            </li>
                            <li>
                                <p><span
                                    style={{fontWeight: "bold"}}>Equipment selection and integration – </span><span>Identify, specify, and design critical process equipment with a focus on compatibility, performance, and long-term reliability</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Regulatory compliance and environmental standards – </span><span>Ensure engineering designs align with global safety regulations, emission controls, and sustainability initiatives</span>
                                </p>
                            </li>
                            <li>
                                <p><span
                                    style={{fontWeight: "bold"}}>Collaborative engineering solutions – </span><span>Leverage expertise from global partners to develop innovative process configurations, maximizing yield and minimizing operational risks</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Construction-ready documentation – </span><span>Deliver technical diagrams, procurement specifications, construction and installation guidelines, and operation manuals for seamless execution and operational excellence</span>
                                </p>
                            </li>
                        </ul>
                    </div>

                    <div className="item">
                        <div className="title">
                            <div className="title-icon">
                                <BlurPublicImage src={"/img/svg/menu/Process debottlenecking.svg"}
                                                 alt={"Process debottlenecking"} width={75} height={75}/>
                            </div>
                            <div className="title-text">
                                <h3>
                                    Process debottlenecking
                                </h3>
                                <p className="subtitle color-secondary">
                                    Optimize plant capacity and process efficiency
                                </p>
                            </div>
                        </div>
                        <div className="desc">
                            <p>
                                Even the most advanced chemical production systems face operational constraints that
                                limit output and efficiency. TranTech Consultants specializes in debottlenecking
                                strategies, identifying and resolving capacity limitations, equipment inefficiencies,
                                and workflow disruptions to maximize throughput and profitability.<br/>
                                Our proprietary process analysis tools benchmark plant performance against 9,000+
                                existing global operations, identifying optimization opportunities that enhance energy
                                efficiency, material utilization, and overall system reliability.
                            </p>
                        </div>
                        <ul className="square-blue-list">
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Bottleneck identification – </span><span>Diagnosing rate-limiting factors across production workflows</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Capacity expansion modeling – </span><span>Developing data-driven scaling strategies for increased output</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Energy and cost optimization – </span><span>Reducing power consumption and material waste through efficiency-focused solutions</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Equipment performance evaluation – </span><span>Assessing reliability, degradation rates, and efficiency gaps in key production equipment</span>
                                </p>
                            </li>
                            <li>
                                <p><span style={{fontWeight: "bold"}}>Supply chain synchronization – </span><span>Optimizing raw material inflow and inventory management to prevent production delays</span>
                                </p>
                            </li>
                        </ul>
                    </div>


                </div>


            </div>

        <div className="blue-section">
            <div className="container">
                <h2>Why choose TranTech consultants?</h2>
                <p className="color-secondary">Engineering excellence, strategic precision, and innovation-driven solutions</p>
                <p>TranTech Consultants merges engineering precision with deep industry intelligence, ensuring that every project benefits from data-driven execution, operational efficiency, and sustainable growth.<br/>
                    Our engineering and design services go beyond conventional approaches, providing tailored technology selection, process refinement, and production scalability—all backed by 9,000+ global plant benchmarks and 8,000+ industry process evaluations. Whether you're implementing new technologies, optimizing existing workflows, or expanding production capacity, our expertise ensures seamless integration, risk mitigation, and long-term profitability.
                </p>
            </div>
        </div>
        <div className="light-blue-section">
            <div className="container">
                <ul className="square-blue-list" style={{marginBottom: "1rem"}}>

                    <li><p><span style={{fontWeight: "bold"}}>Seamless technology integration – </span><span>Select, license, and optimize process technologies with proven long-term success</span>
                    </p></li>
                    <li><p><span style={{fontWeight: "bold"}}>AI-powered predictive modeling – </span><span>Evaluate production scenarios and optimize energy efficiency with real-time insights</span>
                    </p></li>
                    <li><p><span style={{fontWeight: "bold"}}>Industry-leading process designs – </span><span>Leverage best-in-class engineering methodologies to maximize yield and performance</span>
                    </p></li>
                    <li><p><span style={{fontWeight: "bold"}}>Scalable engineering frameworks – </span><span>Develop foundational process designs that align with evolving industry needs</span>
                    </p></li>

                </ul>

                <p className="color-primary bold" style={{fontSize: "1.2rem"}}>We don’t just design processes—we engineer sustainable, high-performing systems that drive industry leadership</p>


            </div>
        </div>

        <div className="container talk-to-an-expert">
            <div>
                <BlurPublicImage src={"/img/svg/Talk.svg"} alt={"Talk to an expert"} width={200} height={100}/>

            </div>
            <div>
                <h3 className="color-primary">Talk to an expert</h3>
                <br/>
                <p className="bold">
                    Turning engineering challenges into strategic opportunities</p>
                <br/>
                <p>TranTech's experts bring 40+ years of process industry experience and deep knowledge of 9,000+ plants and 8,000+ processes to your unique challenges.
                    <br/>
                    <br/>
                Unsure which production route maximizes efficiency for your facility? Need expert insights on technology licensing and cost-benefit analysis? Evaluating energy reduction strategies or process scalability? Our team of industry specialists and process engineers works alongside global partners to craft data-backed solutions tailored to your operational goals. We combine engineering intelligence, market expertise, and cutting-edge technologies to solve complex challenges efficiently.
                    <br/>
                    <br/>
                Connect with TranTech Consultants today—let’s transform your engineering vision into a high-performance reality. Whether you're refining existing operations, expanding production capacity, or rethinking process workflows, our experts provide strategic clarity and technical precision to drive measurable success.
                </p>
                    <br/>

                    <button className="btn-blue">Book a demo call<i className="fa-regular fa-arrow-right"></i></button>
                    <br/>
                    <button className="btn-blue">Contact us<i className="fa-regular fa-arrow-right"></i></button>


                </div>
            </div>

        </div>)
}


export default Page;