document.addEventListener('DOMContentLoaded', function () {
    const menuLabels = document.querySelectorAll('.cat-list > label');
    let openMenu = null;
    let isAnimating = false;

    function closeAllMenus() {
        if (isAnimating) return;
        isAnimating = true;

        const allSubmenus = document.querySelectorAll('.submenu');
        allSubmenus.forEach(submenu => {
            submenu.style.opacity = '0';
            submenu.style.transform = 'translateY(-20px)';
        });

        setTimeout(() => {
            allSubmenus.forEach(submenu => {
                submenu.style.display = 'none';
            });
            isAnimating = false;
            openMenu = null;

            // Reset descriptions
            document.querySelectorAll('.cat-list').forEach(menuItem => {
                const defaultDesc = menuItem.querySelector('.default-desc');
                if (defaultDesc) {
                    defaultDesc.style.display = 'block';
                }
                menuItem.querySelectorAll('.desc[data-desc-id]').forEach(desc => {
                    desc.style.display = 'none';
                });
            });
        }, 300);
    }

    document.addEventListener('mousedown', function (e) {
        if (isAnimating) return;

        if (
            e.target.classList.contains('menu-overlay') ||
            (!e.target.closest('.cat-list') && !e.target.closest('.submenu'))
        ) {
            closeAllMenus();
            return;
        }
    });

    menuLabels.forEach(label => {
        label.addEventListener('mousedown', function (e) {
            if (isAnimating) return;
            e.stopPropagation();

            const menuItem = this.closest('.cat-list');
            const submenu = menuItem.querySelector('.submenu');
            if (!submenu) return;

            if (openMenu === menuItem) {
                closeAllMenus();
                return;
            }

            closeAllMenus();

            setTimeout(() => {
                submenu.style.display = 'block';
                requestAnimationFrame(() => {
                    submenu.style.opacity = '1';
                    submenu.style.transform = 'translateY(0)';
                });
                openMenu = menuItem;

                // Reset description inside current menu
                const defaultDesc = menuItem.querySelector('.default-desc');
                if (defaultDesc) {
                    defaultDesc.style.display = 'block';
                }
                menuItem.querySelectorAll('.desc[data-desc-id]').forEach(desc => {
                    desc.style.display = 'none';
                });
            }, 300);
        });
    });

    // Update description on hover
    const submenuItems = document.querySelectorAll('.submenu-list ul li[data-subcat-id]');

    submenuItems.forEach(item => {
        item.addEventListener('mouseenter', function () {
            const descId = this.getAttribute('data-subcat-id');
            const menuItem = this.closest('.cat-list');
            const targetDesc = menuItem.querySelector(`.desc[data-desc-id="${descId}"]`);
            const defaultDesc = menuItem.querySelector('.default-desc');

            if (targetDesc && defaultDesc) {
                defaultDesc.innerHTML = targetDesc.innerHTML;
            }
        });
    });
});
